using System;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Spells;
using Server.Engines.CannedEvil;
using Server.Network;

namespace Server.Mobiles
{
	public class Rizarox : BaseChampion
	{
		public static Type[] ExtraLoot = new Type[]
		{
			typeof(Broadsword)
		};

		public override bool ClickTitle { get { return false; } }
		public override bool ShowFameTitle { get { return false; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool BleedImmune { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ArmorIgnore : WeaponAbility.CrushingBlow;
		}

		private DateTime m_Delay = DateTime.Now;
		private DateTime m_SilenceDelay = DateTime.Now;
		private DateTime m_FieldDelay = DateTime.Now;
		private DateTime m_SummonDelay = DateTime.Now;

		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		[Constructable]
		public Rizarox() : this (false, 5)
		{
		}

		[Constructable]
		public Rizarox(int range) : this (false, range)
		{
		}

		[Constructable]
		public Rizarox(bool ischampion, int range) : base(AIType.AI_Necromage, FightMode.Closest, ischampion, range)
		{
			Title = ", ledovy demon";
			Body = 43;
			BaseSoundID = 357;
			Name = "Rizarox";

			DropMin = 50;
			DropMax = 100;
			DropType = ChampDrop.DemonDust;
			BonusLoot = "talentscroll";
			BonusLootAmount = 1;

			SetStr(700, 720);
			SetDex(1000, 1100);
			SetInt(1000, 1200);

			SetHits(99000);
			SetMana(2500);
			SetStam(1000);

			SetDamage(25, 26);

			SetDamageType(ResistanceType.Cold, 70);
			SetDamageType(ResistanceType.Physical, 30);

			SetResistance(ResistanceType.Physical, 70, 75);
			SetResistance(ResistanceType.Fire, 70, 75);
			SetResistance(ResistanceType.Cold, 100);
			SetResistance(ResistanceType.Poison, 100);
			SetResistance(ResistanceType.Energy, 100);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 120.6, 130.5);
			SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
			SetSkill(SkillName.Magery, 150.1, 160.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 100.1);
			SetSkill(SkillName.Tactics, 190.0);
			SetSkill(SkillName.Anatomy, 100.0);
			SetSkill(SkillName.Wrestling, 115.1, 130.0);
			SetSkill(SkillName.Swords, 115.1, 120.0);

			Fame = 10000;
			Karma = -15000;

			PackNecroReg(60, 100);

			if(0.1 > Utility.RandomDouble())
				PackItem(ClothingSkillScroll.CreateRandomNoCraft(1, Utility.RandomList(1, 1, 1, 1, 1, 1, 2, 2, 3)));

			if(0.025 > Utility.RandomDouble())
				PackItem((Item)Activator.CreateInstance(ExtraLoot[Utility.Random(ExtraLoot.Length)]));
		}

		public override bool OnBeforeDeath()
		{
			Server.Regions.KhaldunRegion.DropHealthOrb(this);
			Server.Regions.KhaldunRegion.DropHealthOrb(this);

			return base.OnBeforeDeath();
		}

		public override void OnKilledBy(Mobile mob)
		{
			base.OnKilledBy(mob);

			if (mob == null)
				return;

			if (Teragon.CheckArtifactChance(mob, this))
				Teragon.GiveArtifactTo(mob, this);
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);
			
			if (from == null)
				return;
			
			if (this.Hits > (this.HitsMax * 90) / 100)
				return;

			if(DateTime.Now > m_SilenceDelay && Utility.RandomDouble() < 0.01)
			{
				if(!KhalAnkur.IsUnderInfluence(from))
				{
					m_SilenceDelay = DateTime.Now + TimeSpan.FromSeconds(60.0);
					KhalAnkur.Silence(from, this);
				}
			}

			if (Utility.RandomDouble() < 0.005 && from.Player)
			{
				KhalAnkur.Waller(4, 4, from);
			}

			if(DateTime.Now > m_FieldDelay)
			{
				m_FieldDelay = DateTime.Now + TimeSpan.FromSeconds(20.0);
				FreezeField(from);
			}

			if(DateTime.Now > m_SummonDelay && Utility.RandomDouble() < 0.1)
			{
				m_SummonDelay = DateTime.Now + TimeSpan.FromSeconds(30.0);
				FixedParticles(0x375A, 1, 17, 0x7DA, 0x960, 0x3, EffectLayer.Waist);
				IceOoze summon = new IceOoze();

				if (Teragon.CheckConvert(summon, this.Location, this.Map))
					summon.IsTeragon = true;

				summon.SetHits(800, 900);
				summon.MoveToWorld(this.Location, this.Map);
			}

			if (DateTime.Now > m_Delay && this.Hits < (this.HitsMax * 30) / 100)
			{
				Server.Regions.KhaldunRegion.DropHealthOrb(this);
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(30, 50));
				// Effects
				Effects.PlaySound(this.Location, this.Map, this.GetAngerSound());
				// 				EffectCircle( this.Location, this.Map, 6, typeof( Skeleton ), this );

				ArrayList targets = Utilitky.GetTargets(this, 6, true);

				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					if (m == null || m.Deleted)
						continue;

					m.RevealingAction();
					m.FixedParticles(0x3709, 1, 30, 9965, 5, 7, EffectLayer.Waist);
					m.FixedParticles(0x376A, 1, 30, 9502, 5, 3, EffectLayer.Waist);
					m.PlaySound(0x231);

					int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(15, 25), m);

					if (m is Xanthos.Interfaces.IEvoCreature)
						auradamage *= 2;

					m.Hits -= auradamage;
					ISTile5.SendDmgPacket(m, auradamage);

					if (m.Hits < 2)
						m.Kill();
				}
			}
		}

		#region Effects
		private void FreezeField(Mobile from)
		{
			int randx = Utility.RandomMinMax(-6, 6);
			int randy = Utility.RandomMinMax(-10, 10);

			if ((randx > -3 && randx < 1) && (randy > -3 && randy < 1))
				randy = 4;

			Point3D p = new Point3D(5673 + randx, 326 + randy, 0);

			Timer.DelayCall(TimeSpan.FromSeconds(3.0), new TimerStateCallback(FieldEffect), new object[] { p, false });
			Timer.DelayCall(TimeSpan.FromSeconds(6.0), new TimerStateCallback(FieldEffect), new object[] { p, false });
			Timer.DelayCall(TimeSpan.FromSeconds(9.0), new TimerStateCallback(FieldEffect), new object[] { p, true });
		}

		private void FieldEffect(object state)
		{
			object[] args = (object[])state;
			Point3D p = (Point3D) args[0];
			bool end = (bool) args[1];

			if (Deleted)
				return;

			Map map = Map.Felucca;

			Effects.PlaySound(p, map, (end) ? 0x20B : 0x5C6);

			if (end)
			{
				foreach(Mobile m in map.GetMobilesInRange(p, 8))
				{
					if (m == null || !m.InLOS(p) || !m.Alive)
						continue;

					if (m is BaseCreature && (((BaseCreature)m).Controlled || ((BaseCreature)m).Summoned))
					{
						m.Freeze(TimeSpan.FromSeconds(20.0));
					}
					else if (m.Player && m.AccessLevel == AccessLevel.Player)
					{
						m.Freeze(TimeSpan.FromSeconds(12.0));

						if (!InRange(m, 2))
						{
							FixedParticles(0x375A, 1, 17, 0x7DA, 0x960, 0x3, EffectLayer.Waist);
							MadSquirrel summon = new MadSquirrel(m, 1.0);
							summon.Name = "a shadow skeleton";
							summon.Body = Utility.RandomList(50, 56);
							summon.BaseSoundID = 0x48D;
							summon.Hue = 1;
							summon.MoveToWorld(this.Location, this.Map);
						}
					}
				}
			}

			for (int i = -8; i <= 8; ++i)
			{
				for (int j = -8; j <= 8; ++j)
				{
					int px = p.X + i;
					int py = p.Y + j;

					if (px > 5679 || px < 5668 || py > 334 || py < 319)
						continue;

					Effects.SendLocationParticles(EffectItem.Create(new Point3D(px, py, p.Z), map, TimeSpan.FromSeconds(15.0)), (end) ? 0x3967 : 0x376A, 10, 15, 5045);
				}
			}
		}

		#endregion

		public override bool AlwaysMurderer { get { return true; } }

		public Rizarox(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			Hits = HitsMax;
			Blessed = false;
		}
	}
}